package jamezo97.clonecraft.dna;

import jamezo97.clonecraft.Logger;
import jamezo97.clonecraft.Reflect;
import jamezo97.clonecraft.entity.EntityModifiable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

import net.minecraft.entity.CCEntityAnything;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.CCEntityPlayerMP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.world.CloneCraftWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

import org.apache.commons.lang3.ArrayUtils;

public abstract class Gene {

	Random rand = new Random();

	private int id;

	public Gene(int id){
		this.id = id;
	}

	public int getId(){
		return id;
	}

	/**
	 * Get's the name of the Gene, ie speed, strength, size etc.
	 * @return
	 */
	public abstract String getName();

	/**
	 * Get's the maximum strength the gene can have upon an entity.
	 * @return
	 */
	public abstract int getMaxAmount();

	/**
	 * Get's a string representing the change on an entity when the buff is active, ie "10% Speed increase", or "x2 Speed"
	 * @param amount
	 * @return
	 */
	public abstract String getStringValue(int amount);

	/**
	 * Get's the colour of the gene, for illustrative purposes only
	 * @return
	 */
	public abstract int getColour();

	/**
	 * Get's the entity ids which this gene applies to, ie the entities you can extract it from.
	 * @return
	 */
	public abstract Class[] getEntityClassesWithGene();


	//EDIT; FYEAH! Not anymore! I figured it out! :D:D
	/**
	 * Used to justify the uselessness of entites:D If this is set to true, then the entity modified will
	 * be converted into an EntityModifiable, and some of the traits will be attempted to be incorporated
	 * into the new Entity, but many will not be possible, from a dynamic persepctive.
	 * @return
	 */
	//public abstract boolean causesBrainDegenration();

	private boolean doesEntityHaveGene(Entity entity){
		Class[] classes = getEntityClassesWithGene();
		if(classes == null || classes.length == 0)return false;
		Class entityClass = entity.getClass();
		for(int a = 0; a < classes.length; a++){
			if(classes[a] == entityClass){
				return true;
			}
		}
		return false;
	}

	public void spawnParticleForEntityForGene(EntityLivingBase entity){
		int i = this.getColour();
		double d0 = (double)(i >> 16 & 255) / 255.0D;
		double d1 = (double)(i >> 8 & 255) / 255.0D;
		double d2 = (double)(i >> 0 & 255) / 255.0D;
		entity.worldObj.spawnParticle("mobSpellAmbient"/* : "mobSpell"*/, entity.posX + (this.rand.nextDouble() - 0.5D) * (double)entity.width, entity.posY + this.rand.nextDouble() * (double)entity.height - (double)entity.yOffset, entity.posZ + (this.rand.nextDouble() - 0.5D) * (double)entity.width, d0, d1, d2);
	}

	public void updateGene(EntityLivingBase entity, IModifiable mod, int level){
		spawnParticleForEntityForGene(entity);
		this.onUpdate(entity, mod, level);
	}

	/**
	 * Run at the end of every tick of the modifiable entity which has this gene applied. 
	 * @param entity
	 * @param level
	 */
	public abstract void onUpdate(EntityLivingBase entity, IModifiable mod, int level);

	/**
	 * Add the gene effect to the entity for the first time. Run once, usually to add a permenant potion effect to the entity.
	 * More complicated Genes should override onEntityUpdate, and induce brain damage (as an excuse to have the entity extend 
	 * the EntityModifiable class
	 * @param entity Entity to apply the gene once-off to.
	 * @param level The level of the gene to apply.
	 */
	public abstract void addGeneEffect(EntityLivingBase entity, int level);


	public EntityLivingBase mutateLivingEntity(EntityLivingBase mutate, int level){
		//		System.out.println("A:" + mutate);
		if(mutate instanceof IModifiable){
			//			System.out.println("MUtate");
			((IModifiable)mutate).setGene(this, level);
			return mutate;
		}else if(mutate instanceof EntityPlayerMP){
			//			Thread.dumpStack();
			CCEntityPlayerMP mutated = new CCEntityPlayerMP((EntityPlayerMP)mutate);
//			mutated.sendChatToPlayer(ChatMessageComponent.createFromText("Well done id: " + mutated.entityId));
			if(!mutate.worldObj.isRemote){
				mutated.setGene(this, level);
				WorldServer world = (WorldServer)mutate.worldObj;
				replacePlayerWithNew((EntityPlayerMP)mutate, mutated);
				/*world.removePlayerEntityDangerously(mutate);
				CloneCraft.instance.spawnEntityAfterOneTick(mutated);
				world.getEntityTracker().removeEntityFromAllTrackingPlayers(mutate);
				world.removeEntity(mutate);


				mutated.getServerForPlayer().getPlayerManager().removePlayer((EntityPlayerMP)mutate);
				mutated.getServerForPlayer().getPlayerManager().addPlayer((EntityPlayerMP)mutated);*/
/*
				EntityTracker tracker = ((WorldServer)mutated.worldObj).getEntityTracker();
				{
					EntityPlayerMP entityplayermp = (EntityPlayerMP)mutated;
					Iterator iterator = Reflect.get(tracker, Reflect.trackedEntities, Set.class).iterator();

					while (iterator.hasNext())
					{
						EntityTrackerEntry entitytrackerentry = (EntityTrackerEntry)iterator.next();

						if (entitytrackerentry.myEntity != entityplayermp)
						{
							entitytrackerentry.tryStartWachingThis(entityplayermp);
						}
					}
				}*/
			}
			return mutated;
		}else if(mutate instanceof EntityLiving){
			int entityId = EntityList.getEntityID(mutate);

			CCEntityAnything custom = new CCEntityAnything(mutate.worldObj, ((EntityLiving)mutate));

			custom.setGene(this, level);

			custom.worldObj.removeEntity(mutate);
			custom.worldObj.spawnEntityInWorld(custom);

			return custom;
		}
		return mutate;
	}

	public void replacePlayerWithNew(EntityPlayerMP player, EntityPlayerMP newPlayer){
		WorldServer world = (WorldServer)player.worldObj;
		
		world.removePlayerEntityDangerously(player);
		
		if(world.loadedEntityList.contains(player)){
			world.loadedEntityList.set(world.loadedEntityList.indexOf(player), newPlayer);
		}else{
			world.loadedEntityList.add(newPlayer);
		}
		if(world.playerEntities.contains(player)){
			world.playerEntities.set(world.playerEntities.indexOf(player), newPlayer);
		}else{
			world.playerEntities.add(newPlayer);
		}
		
		CloneCraftWorld.onEntityAdded(world, newPlayer);
		
		player.getServerForPlayer().getPlayerManager().removePlayer(player);
		newPlayer.getServerForPlayer().getPlayerManager().addPlayer(newPlayer);
		
		
        int i = player.chunkCoordX;
        int j = player.chunkCoordZ;

        if (player.addedToChunk && CloneCraftWorld.chunkExists(world, i, j))
        {
            world.getChunkFromChunkCoords(i, j).removeEntity(player);
            world.getChunkFromChunkCoords(i, j).addEntity(newPlayer);
        }
		
		EntityTracker tracker = ((WorldServer)player.worldObj).getEntityTracker();

		Iterator iterator = Reflect.get(tracker, Reflect.trackedEntities, Set.class).iterator();

		while (iterator.hasNext())
		{
			EntityTrackerEntry entry = (EntityTrackerEntry)iterator.next();
			if(entry != null){
				if(entry.myEntity == player){
					entry.myEntity = newPlayer;
				}else{
					if(entry.trackingPlayers.contains(player)){
						entry.trackingPlayers.remove(player);
						entry.trackingPlayers.add(newPlayer);
					}
				}
			}
		}

	}

	private static HashMap<Integer, Gene> idToGene = new HashMap<Integer, Gene>();

	private static Gene[] geneArray = null;

	private static ArrayList<Integer> ids = new ArrayList<Integer>();

	public static int[] getAllGeneIds(){
		return ArrayUtils.toPrimitive(ids.toArray(new Integer[ids.size()]));
	}

	public static Gene getGene(int id){
		Gene g = idToGene.get(id);
		return g;
	}

	private static void addGene(Gene gene){
		if(!ids.contains(gene.id)){
			ids.add(gene.id);
			idToGene.put(gene.id, gene);
		}else{
			Logger.error("Gene with id '" + gene.id + "' is already registered!");
		}
	}

	public Gene[] getGenesForEntity(Entity entity){
		ArrayList<Gene> genes = new ArrayList<Gene>();
		for(int a = 0; a < ids.size(); a++){
			int id = ids.get(a);
			Gene gene = getGene(id);
			if(gene.doesEntityHaveGene(entity)){
				genes.add(gene);
			}
		}
		return genes.toArray(new Gene[genes.size()]);
	}


	public static float getGeneScaling(EntityModifiable entity){
		float scale = 1;
		if(entity.hasGene(Gene.large)){
			scale = entity.getGeneStrength(Gene.large);
		}
		if(entity.hasGene(Gene.small)){
			scale = scale / ((float)entity.getGeneStrength(Gene.small));
		}
		return scale;
	}

	public static Gene speedIncrease, speedDecrease, evil, passive, large, small, fireProof, marine,
	superJump, teleport;

	public static void registerGenes(){
		addGene(speedIncrease = new GeneSpeedIncrease(0));
		addGene(speedDecrease = new GeneSpeedDecrease(1));
		addGene(evil = new GeneEvil(2));
		addGene(passive = new GenePassive(3));
		addGene(large = new GeneLarge(4));
		addGene(small = new GeneSmall(5));
		addGene(fireProof = new GeneFireProof(6));
		addGene(marine = new GeneMarine(7));
		addGene(superJump = new GeneSuperJump(8));
		addGene(teleport = new GeneTeleport(9));
	}

	static{
		registerGenes();
	}
	//entity.tasks.addTask(par1, par2EntityAIBase);
	//Speed (fast/slow), regeneration, strength, evil, flying, giant

	/*    addMapping(EntityCreeper.class, "Creeper", 50, 894731, 0);
    addMapping(EntitySkeleton.class, "Skeleton", 51, 12698049, 4802889);
    addMapping(EntitySpider.class, "Spider", 52, 3419431, 11013646);
    addMapping(EntityGiantZombie.class, "Giant", 53);
    addMapping(EntityZombie.class, "Zombie", 54, 44975, 7969893);
    addMapping(EntitySlime.class, "Slime", 55, 5349438, 8306542);
    addMapping(EntityGhast.class, "Ghast", 56, 16382457, 12369084);
    addMapping(EntityPigZombie.class, "PigZombie", 57, 15373203, 5009705);
    addMapping(EntityEnderman.class, "Enderman", 58, 1447446, 0);
    addMapping(EntityCaveSpider.class, "CaveSpider", 59, 803406, 11013646);
    addMapping(EntitySilverfish.class, "Silverfish", 60, 7237230, 3158064);
    addMapping(EntityBlaze.class, "Blaze", 61, 16167425, 16775294);
    addMapping(EntityMagmaCube.class, "LavaSlime", 62, 3407872, 16579584);
    addMapping(EntityDragon.class, "EnderDragon", 63);
    addMapping(EntityWither.class, "WitherBoss", 64);
    addMapping(EntityBat.class, "Bat", 65, 4996656, 986895);
    addMapping(EntityWitch.class, "Witch", 66, 3407872, 5349438);
    addMapping(EntityPig.class, "Pig", 90, 15771042, 14377823);
    addMapping(EntitySheep.class, "Sheep", 91, 15198183, 16758197);
    addMapping(EntityCow.class, "Cow", 92, 4470310, 10592673);
    addMapping(EntityChicken.class, "Chicken", 93, 10592673, 16711680);
    addMapping(EntitySquid.class, "Squid", 94, 2243405, 7375001);
    addMapping(EntityWolf.class, "Wolf", 95, 14144467, 13545366);
    addMapping(EntityMooshroom.class, "MushroomCow", 96, 10489616, 12040119);
    addMapping(EntitySnowman.class, "SnowMan", 97);
    addMapping(EntityOcelot.class, "Ozelot", 98, 15720061, 5653556);
    addMapping(EntityIronGolem.class, "VillagerGolem", 99);
    addMapping(EntityHorse.class, "EntityHorse", 100, 12623485, 15656192);
    addMapping(EntityVillager.class, "Villager", 120, 5651507, 12422002);*/

	/*  public static final Potion moveSpeed = (new Potion(1, false, 8171462)).setPotionName("potion.moveSpeed").setIconIndex(0, 0).func_111184_a(SharedMonsterAttributes.field_111263_d, "91AEAA56-376B-4498-935B-2F7F68070635", 0.20000000298023224D, 2);
    public static final Potion moveSlowdown = (new Potion(2, true, 5926017)).setPotionName("potion.moveSlowdown").setIconIndex(1, 0).func_111184_a(SharedMonsterAttributes.field_111263_d, "7107DE5E-7CE8-4030-940E-514C1F160890", -0.15000000596046448D, 2);
    public static final Potion digSpeed = (new Potion(3, false, 14270531)).setPotionName("potion.digSpeed").setIconIndex(2, 0).setEffectiveness(1.5D);
    public static final Potion digSlowdown = (new Potion(4, true, 4866583)).setPotionName("potion.digSlowDown").setIconIndex(3, 0);
    public static final Potion damageBoost = (new PotionAttackDamage(5, false, 9643043)).setPotionName("potion.damageBoost").setIconIndex(4, 0).func_111184_a(SharedMonsterAttributes.field_111264_e, "648D7064-6A60-4F59-8ABE-C2C23A6DD7A9", 3.0D, 2);
    public static final Potion heal = (new PotionHealth(6, false, 16262179)).setPotionName("potion.heal");
    public static final Potion harm = (new PotionHealth(7, true, 4393481)).setPotionName("potion.harm");
    public static final Potion jump = (new Potion(8, false, 7889559)).setPotionName("potion.jump").setIconIndex(2, 1);
    public static final Potion confusion = (new Potion(9, true, 5578058)).setPotionName("potion.confusion").setIconIndex(3, 1).setEffectiveness(0.25D);

	 *//** The regeneration Potion object. *//*
    public static final Potion regeneration = (new Potion(10, false, 13458603)).setPotionName("potion.regeneration").setIconIndex(7, 0).setEffectiveness(0.25D);
    public static final Potion resistance = (new Potion(11, false, 10044730)).setPotionName("potion.resistance").setIconIndex(6, 1);

	  *//** The fire resistance Potion object. *//*
    public static final Potion fireResistance = (new Potion(12, false, 14981690)).setPotionName("potion.fireResistance").setIconIndex(7, 1);

	   *//** The water breathing Potion object. *//*
    public static final Potion waterBreathing = (new Potion(13, false, 3035801)).setPotionName("potion.waterBreathing").setIconIndex(0, 2);

	    *//** The invisibility Potion object. *//*
    public static final Potion invisibility = (new Potion(14, false, 8356754)).setPotionName("potion.invisibility").setIconIndex(0, 1);

	     *//** The blindness Potion object. *//*
    public static final Potion blindness = (new Potion(15, true, 2039587)).setPotionName("potion.blindness").setIconIndex(5, 1).setEffectiveness(0.25D);

	      *//** The night vision Potion object. *//*
    public static final Potion nightVision = (new Potion(16, false, 2039713)).setPotionName("potion.nightVision").setIconIndex(4, 1);

	       *//** The hunger Potion object. *//*
    public static final Potion hunger = (new Potion(17, true, 5797459)).setPotionName("potion.hunger").setIconIndex(1, 1);

	        *//** The weakness Potion object. *//*
    public static final Potion weakness = (new PotionAttackDamage(18, true, 4738376)).setPotionName("potion.weakness").setIconIndex(5, 0).func_111184_a(SharedMonsterAttributes.field_111264_e, "22653B89-116E-49DC-9B6B-9971489B5BE5", 2.0D, 0);

	         *//** The poison Potion object. *//*
    public static final Potion poison = (new Potion(19, true, 5149489)).setPotionName("potion.poison").setIconIndex(6, 0).setEffectiveness(0.25D);

	          *//** The wither Potion object. *//*
    public static final Potion wither = (new Potion(20, true, 3484199)).setPotionName("potion.wither").setIconIndex(1, 2).setEffectiveness(0.25D);
    public static final Potion field_76434_w = (new PotionHealthBoost(21, false, 16284963)).setPotionName("potion.healthBoost").setIconIndex(2, 2).func_111184_a(SharedMonsterAttributes.field_111267_a, "5D6F0BA2-1186-46AC-B896-C61C5CEE99CC", 4.0D, 0);
    public static final Potion field_76444_x = (new PotionAbsoption(22, false, 2445989)).setPotionName("potion.absorption").setIconIndex(2, 2);
    public static final Potion field_76443_y = (new PotionHealth(23, false, 16262179)).setPotionName("potion.saturation");
    public static final Potion field_76442_z = null;
    public static final Potion field_76409_A = null;
    public static final Potion field_76410_B = null;
    public static final Potion field_76411_C = null;
    public static final Potion field_76405_D = null;
    public static final Potion field_76406_E = null;
    public static final Potion field_76407_F = null;
    public static final Potion field_76408_G = null;*/

}
